﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Dokumenty wg serii</title>

    <script runat="server"> 

        static DokumentyParams dparametry;

        [Context(Required = false)]
        public static DokumentyParams DParametry {
            get { return dparametry; }
            set { dparametry = value; }
        }
        
        public class ParametryContext : ContextBase
        {
            public ParametryContext(Context cx)
                : base(cx)
            {
            }

            bool _ignorujZaliczkowe = true;

            [Priority(10)]
            public bool IgnorujZaliczkowe
            {
                get { return _ignorujZaliczkowe; }
                set { _ignorujZaliczkowe = value; OnChanged(EventArgs.Empty); }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry
        {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total : IComparable
        {
            readonly string seria;
            decimal netto = 0;
            decimal vat = 0;
            decimal brutto = 0;
            int liczba = 0;

            public Total(string seria)
            {
                this.seria = seria;
            }
            public void Add(DokumentHandlowy dok)
            {
                netto += dok.Suma.Netto;
                vat += dok.Suma.VAT;
                brutto += dok.Suma.Brutto;
                ++liczba;
            }
            public string Seria
            {
                get { return seria; }
            }
            public int Liczba
            {
                get { return liczba; }
            }
            public decimal Netto
            {
                get { return netto; }
            }
            public decimal Brutto
            {
                get { return brutto; }
            }
            public decimal VAT
            {
                get { return vat; }
            }
            public int CompareTo(object obj)
            {
                Total t = (Total)obj;
                return string.Compare(Seria, t.Seria);
            }
        }

        void OnContextLoad(Object sender, EventArgs args)
        {
        
            if (DParametry != null) {
                string partia = CaptionAttribute.EnumToString(DParametry.FiltrTypuPartii);
                string typ = CaptionAttribute.EnumToString(DParametry.FiltrTypu);
                string linia = "|Partia: <STRONG>" + partia + "</STRONG>, Typ: <STRONG>" + typ + "</STRONG>";
                ReportHeader.Title += linia;
            }
            
            Row[] rows = (Row[])dc[typeof(Row[])];
            Hashtable result = new Hashtable();
            int licznik = 0;
            foreach (DokumentHandlowy dokument in rows)
            {
                if (++licznik % 30 == 0)
                    System.Diagnostics.Trace.Write(licznik * 100 / rows.Length, "Progress");
                System.Diagnostics.Trace.Write(dokument, "Progress");
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;
                if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                Total t = (Total)result[dokument.Seria];
                if (t == null)
                {
                    t = new Total(dokument.Seria);
                    result.Add(dokument.Seria, t);
                }
                t.Add(dokument);
            }

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Dokumenty wg serii</STRONG>|Okres:<STRONG> {2}</STRONG>|Magazyn:<STRONG> {3}</STRONG>"
            runat="server" DataMember3="Magazyn" DataMember2="FromTo"></eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
            <Columns>
                <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn DataMember="Seria" Total="Info" EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="VAT" Total="Sum" Format="{0:n}"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="15" Align="Right" DataMember="Brutto" Total="Sum" Format="{0:n}"
                    EncodeHTML="True" runat="server">
                </ea:GridColumn>
                <ea:GridColumn Width="8" Align="Right" DataMember="Liczba" Total="Sum" EncodeHTML="True"
                    runat="server">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>

